<?php

namespace App\Http\Controllers;

use App\Models\Entity\Cartao;
use App\Models\Entity\CartaoCliente;
use App\Models\Entity\Dependente;
use App\Models\Facade\DependenteDB;
use App\Models\Regras\DependenteRegras;
use Exception;
use Illuminate\Http\Request;

class DependenteController extends Controller
{
    public function store(Request $request)
    {
        try {
            if(!$request->id)
                DependenteRegras::salvar($request);
            else
                DependenteRegras::alterar($request);


            $request->session()->flash('sucesso', 'Dados do dependente salvos com sucesso.');

            return response()->json([]);
        } catch(Exception $ex) {
            return response()->json(['error' => $ex->getMessage()], 500);
        }
    }

    public function edit($id)
    {
        return response()->json(DependenteDB::find($id));
    }

    public function ativar($id)
    {
        try {
            DependenteRegras::ativar($id);

            request()->session()->flash('sucesso', 'Dependente ativado com sucesso.');

            return response()->json([]);
        }
        catch(Exception $ex) {
            return response()->json(['error' => $ex->getMessage()], 500);
        }
    }

    public function inativar($id)
    {
        try {
            DependenteRegras::inativar($id);

            request()->session()->flash('sucesso', 'Dependente inativado com sucesso.');

            return response()->json([]);
        }
        catch(Exception $ex) {
            return response()->json(['error' => $ex->getMessage()], 500);
        }
    }

}
